<?php namespace Visiosoft\RecommendedadsModule\Recommend;

use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\RecommendedadsModule\Recommend\Contract\RecommendRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class RecommendRepository extends EntryRepository implements RecommendRepositoryInterface
{
    protected $model;
    protected $advRepository;
    protected $categoryRepository;

    public function __construct(
        RecommendModel $model,
        AdvRepositoryInterface $advRepository,
        CategoryRepositoryInterface $categoryRepository
    )
    {
        $this->model = $model;
        $this->advRepository = $advRepository;
        $this->categoryRepository = $categoryRepository;
    }

    public function findByCategoryAndUser($categoryID, $userID = null)
    {
        $userID = auth_id_if_null($userID);

        return $this->getModel()
            ->where([
                'category_id' => $categoryID,
                'created_by_id' => $userID,
            ])
            ->first();
    }

    public function getUserRecommended($userID = null, $limit = 10)
    {
        $userID = auth_id_if_null($userID);

        $recommendedCats = $this->getUserRecommendedCats($userID);

        $cats = array();
        foreach ($recommendedCats as $cat) {
            $level = $this->categoryRepository->getLevelById($cat->id);

            if (isset($cats[$level])) {
                $cats[$level] = array_merge($cats[$level], [$cat->id]);
            } else {
                $cats[$level] = [$cat->id];
            }
        }

        return $this->advRepository->getClassifiedsByCatsIDsAndLevels($cats, $limit);
    }

    public function getUserRecommendedCats($userID = null, $limit = 10)
    {
        $userID = auth_id_if_null($userID);

        $recommended = $this->getModel()
            ->where('created_by_id', $userID)
            ->orderBy('updated_at')
            ->limit($limit)
            ->get();

        $cats = array();
        foreach ($recommended as $entry) {
            $cats[] = $entry->category;
        }

        return $cats;
    }
}
