<?php namespace Visiosoft\RecentlyviewedadsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\AdvsModule\Adv\Event\viewAd;
use Visiosoft\RecentlyviewedadsModule\Recently\Contract\RecentlyRepositoryInterface;
use Visiosoft\RecentlyviewedadsModule\Recently\Listener\Recently;
use Visiosoft\RecentlyviewedadsModule\Recently\RecentlyRepository;
use Anomaly\Streams\Platform\Model\Recentlyviewedads\RecentlyviewedadsRecentlyEntryModel;
use Visiosoft\RecentlyviewedadsModule\Recently\RecentlyModel;
use Illuminate\Routing\Router;

class RecentlyviewedadsModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/recentlyviewedads'           => 'Visiosoft\RecentlyviewedadsModule\Http\Controller\Admin\RecentlyController@index',
        'admin/recentlyviewedads/create'    => 'Visiosoft\RecentlyviewedadsModule\Http\Controller\Admin\RecentlyController@create',
        'admin/recentlyviewedads/edit/{id}' => 'Visiosoft\RecentlyviewedadsModule\Http\Controller\Admin\RecentlyController@edit',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\RecentlyviewedadsModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\RecentlyviewedadsModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        viewAd::class => [
            Recently::class,
        ]
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\RecentlyviewedadsModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        RecentlyviewedadsRecentlyEntryModel::class => RecentlyModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        RecentlyRepositoryInterface::class => RecentlyRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
