<?php namespace Visiosoft\RecentlyviewedadsModule\Recently\Listener;

use Illuminate\Contracts\Events\Dispatcher;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use JSMin\UnterminatedStringException;
use Visiosoft\AdvsModule\Adv\Event\viewAd;
use Visiosoft\RecentlyviewedadsModule\Recently\RecentlyModel;


class Recently
{
    public function __construct(Dispatcher $events)
    {
        $this->model = new RecentlyModel();
        $this->events = $events;
    }

    public function handle(viewAd $event)
    {
        if (!Auth::user()) {
            setcookie("ad[" . $event->request->id . "]", $event->request->id, time() + 3600, '/', NULL, 0);
        } else {
            if(isset($_COOKIE['ad']))
            {
                foreach ($_COOKIE['ad'] as $adv)
                {
                    $this->model->create(['adv_id' => $adv]);
                    setcookie("ad[" . $adv . "]", null, -1, '/');
                }
            }
            $this->model->create(['adv_id' => $event->request->id,'author_id' => auth()->id()]);
        }
    }


}
