<?php namespace Visiosoft\RecentlyviewedadsModule\Recently;

use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\RecentlyviewedadsModule\Recently\Contract\RecentlyRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class RecentlyRepository extends EntryRepository implements RecentlyRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var RecentlyModel
     */
    protected $model;

    /**
     * @var AdvModel
     */
    protected $advModel;

    /**
     * RecentlyRepository constructor.
     * @param RecentlyModel $model
     * @param AdvModel $advModel
     */
    public function __construct(RecentlyModel $model, AdvModel $advModel)
    {
        $this->model = $model;
        $this->advModel = $advModel;
    }

    /**
     * @return mixed
     */
    public function getRecently()
    {
        $recently_Ads = $this->model->where('author_id', Auth::id())->pluck('adv_id');

        $recently = $this->advModel->whereIn('advs_advs.id', $recently_Ads)->get();

        if (count($recently)) {
            foreach ($recently as $index => $ad) {
                $recently[$index]->detail_url = $this->advModel->getAdvDetailLinkByModel($ad, 'list');
                $recently[$index] = $this->advModel->AddAdsDefaultCoverImage($ad);
            }
            return $recently;
        }
        return null;
    }
}
