<?php namespace Visiosoft\RasyonelTheme\Seed;

use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Database\Seeder;


class RepeaterSeeder extends Seeder
{
    protected $streamRepository;
    protected $fieldsRepository;
    protected $assignmentsRepository;

    public function __construct(
        StreamRepositoryInterface $streamRepository,
        FieldRepositoryInterface $fieldsRepository,
        AssignmentRepositoryInterface $assignmentsRepository
    )
    {
        $this->streamRepository = $streamRepository;
        $this->fieldsRepository = $fieldsRepository;
        $this->assignmentsRepository = $assignmentsRepository;
    }

    public function run()
    {
        //Collect repeater
        $repeaters = [
            'about_us' => [
                'content' => [
                    'name' => 'About Us',
                    'namespace' => 'repeater',
                    'slug' => 'about_us',
                ],
                'fields' => ['header_text', 'subtext']
            ],
            'sertificate' => [
                'content' => [
                    'name' => 'Sertificate',
                    'namespace' => 'repeater',
                    'slug' => 'sertificate',
                ],
                'fields' => ['img']
            ],
        ];

        // Collect Repeater Fields
        $repeater_fields = [
            'header_text' => [
                'field_attributes' => [
                    'name' => 'Header Text',
                    'namespace' => 'repeater',
                    'slug' => 'header_text',
                    'type' => 'anomaly.field_type.text',
                    'locked' => 0,
                    'config' => [
                        'default_value' => '',
                    ],
                ],
                'assignment_attributes' => [
                    'required' => true,
                    'translatable' => true,
                ]
            ],
            'subtext' => [
                'field_attributes' => [
                    'name' => 'Subtext',
                    'namespace' => 'repeater',
                    'slug' => 'subtext',
                    'type' => 'anomaly.field_type.text',
                    'locked' => 0,
                    'config' => [
                        "type" => "text",
                        'default_value' => '',
                        "max"           => 550,
                        "show_counter"  => true,
                    ],
                ],
                'assignment_attributes' => [
                    'required' => true,
                    'translatable' => true,
                ]
            ],
            'img' => [
                'field_attributes' => [
                    'name' => 'Image',
                    'namespace' => 'repeater',
                    'slug' => 'img',
                    'type' => 'anomaly.field_type.file',
                    'instructions' => 'Recommended 120x120',
                    "config" => [
                        "folders" => ['images'],
                        "mode" => 'upload',
                    ],
                ],
                'assignment_attributes' => [
                    'required' => true,
                ]
            ],

        ];

        foreach ($repeaters as $slug => $repeater) {
            if (!$repeater_stream = $this->streamRepository->findBySlugAndNamespace($slug, 'repeater')) {
                $repeater_stream = $this->streamRepository->create($repeater['content']);
            }

            foreach ($repeater['fields'] as $field_slug) {
                $field_repeater = $repeater_fields[$field_slug];
                if (!$field = $this->fieldsRepository->findBySlugAndNamespace($field_slug, 'repeater')) {
                    $field = $this->fieldsRepository->create($field_repeater['field_attributes']);
                }

                if (!$this->assignmentsRepository->findByStreamAndField($repeater_stream, $field)) {
                    $this->assignmentsRepository->create(
                        array_merge([
                            'stream' => $repeater_stream,
                            'field' => $field,
                        ], $field_repeater['assignment_attributes'])
                    );
                }
            }
        }

    }
}