<?php

return [
    "phone_number" => "anomaly.field_type.integer",
    "mail_address" => "anomaly.field_type.text",
    "privacy_policy_text" => "anomaly.field_type.text",
    "location_address" => "anomaly.field_type.text",
    "instagram_url" => "anomaly.field_type.url",
    "twitter_url" => "anomaly.field_type.url",
    "linkedin_url" => "anomaly.field_type.url",
    "allArticles" => "anomaly.field_type.boolean",
    'company_first_input_link' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'company_location' => [
        'type' => 'anomaly.field_type.text',
        "config" => [
            "max"           => 150000,
            "default_value" => `<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d22778138.479390662!2d-8.40723414629234!3d45.82058069745691!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x42ac5358cb25e3e5%3A0xf5800deaa1950432!2sMapilio!5e0!3m2!1str!2str!4v1692261061486!5m2!1str!2str" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>`,
        ]
    ],
    'category_bg' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    "company_first_input_number" => "anomaly.field_type.integer",
    "company_first_input" => "anomaly.field_type.text",
    'company_second_input_link' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    "company_second_input_number" => "anomaly.field_type.integer",
    "company_second_input" => "anomaly.field_type.text",
    'company_third_input_link' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    "company_third_input_number" => "anomaly.field_type.integer",
    "company_third_input" => "anomaly.field_type.text",
    'white_logo' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'dark_logo' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'footer_logo' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'post_input_one' => [
        "type" => "anomaly.field_type.relationship",
        "config" => [
            "related" => \Anomaly\PostsModule\Category\CategoryModel::class,
            "default_value" => null,
        ]
    ],
    'post_input_two' => [
        "type" => "anomaly.field_type.relationship",
        "config" => [
            "related" => \Anomaly\PostsModule\Category\CategoryModel::class,
            "default_value" => null,
        ]
    ],
    'post_input_three' => [
        "type" => "anomaly.field_type.relationship",
        "config" => [
            "related" => \Anomaly\PostsModule\Category\CategoryModel::class,
            "default_value" => null,
        ]
    ],
    'under_slider_link' => [
        "type" => "anomaly.field_type.relationship",
        "config" => [
            "related" => \Anomaly\NavigationModule\Link\LinkModel::class,
            "mode" => "lookup",
            "title_name" => 'link',
            "handler" => "\Anomaly\RelationshipFieldType\Handler\Related@handle",
        ]
    ],
    'background_under_slider' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'first_post_area_image' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'second_post_area_image' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    "header_post_categroies" => [
        'type' => 'anomaly.field_type.checkboxes',
        'config' => [
            'handler' => 'Visiosoft\RasyonelTheme\SettingHandler\PostCategoriesOptions@handle'
        ],
    ]
];
