<?php

namespace Visiosoft\RasyonelTheme\SettingHandler;

use Anomaly\CheckboxesFieldType\CheckboxesFieldType;
use Anomaly\PostsModule\Category\Contract\CategoryRepositoryInterface;

class PostCategoriesOptions
{
    private $postCategoryRepository;

    public function __construct(CategoryRepositoryInterface $postCategoryRepository)
    {
        $this->postCategoryRepository = $postCategoryRepository;
    }

    public function handle(CheckboxesFieldType $fieldType)
    {
        $postCategories = $this->postCategoryRepository->newQuery()->whereNull('parent_category_id')->get();
        $options = array();
        foreach ($postCategories as $postCategory) {
            $options[$postCategory->id] = $postCategory->name;
        }
        $fieldType->setOptions($options);
    }
}
