<?php

namespace Visiosoft\RasyonelTheme;

use Anomaly\PostsModule\Post\PostRepository;
use Anomaly\PostsModule\Category\CategoryRepository;
use Anomaly\Streams\Platform\Addon\Plugin\Plugin;

class RasyonelThemePlugin extends Plugin
{
    protected $postRepository;
    protected $categoryRepository;

    public function __construct(PostRepository $postRepository, CategoryRepository $categoryRepository)
    {
        $this->postRepository = $postRepository;
        $this->categoryRepository = $categoryRepository;
    }

    public function getFunctions(): array
    {
        return [
            new \Twig_SimpleFunction(
                'getPostsByCategoryIDs',
                function ($category_ids) {
                    return $this->postRepository->newQuery()->with('type')->whereIn('category_id', $category_ids)->get();
                }
            ),
        ];
    }
}
