if ($('.fade-slider-main').length) {
    $('.fade-slider-main').slick({
        infinite: true,
        speed: 500,
        fade: true,
        cssEase: 'linear'
    });
}

if ($('.slick-3').length) {
    $('.slick-3').slick({
        arrows: false,
        dots: true,
        speed: 500,
        slidesToShow: 3,
        slidesToScroll: 2,
        autoplay: true,
        autoplaySpeed: 2000,
        responsive: [
            {
                breakpoint: 1024,
                settings: {
                    slidesToShow: 2,
                    slidesToScroll: 1,
                    dots: true
                }
            },
            {
                breakpoint: 768,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    dots: true
                }
            },
        ]
    });
}



$(document).ready(() => {

    const backToTop = $('#backToTop')
    const amountScrolled = 100

    $(window).scroll(() => {
        $(window).scrollTop() >= amountScrolled
            ? backToTop.fadeIn('fast')
            : backToTop.fadeOut('fast')
    })

    backToTop.click(() => {
        $('body, html').animate({
            scrollTop: 0
        }, 600)
        return false
    })
})

$(window).scroll(function () {
    var scrolled_val = $(document).scrollTop().valueOf();
    var header_nav = $(".header-nav");
    if (scrolled_val > 30) {
        if (!header_nav.hasClass('transTop'))
            header_nav.addClass('transTop');
    } else {
        if (header_nav.hasClass('transTop'))
            header_nav.removeClass('transTop');
    }
});

$('.burger-menu, .close-burger').on('click', () => {
    $(".mobile-navbar").toggleClass("mobile-translate");
    $("body").toggleClass("overflow-hidden");
})

AOS.init();