AOS.init();

if ($('.fade-slider-main').length) {
    $('.fade-slider-main').slick({
        infinite: true,
        speed: 500,
        fade: true,
        cssEase: 'linear'
    });
}

if ($('.slick-3').length) {
    $('.slick-3').slick({
        dots: true,
        speed: 500,
        slidesToShow: 3,
        slidesToScroll: 2,
        autoplaySpeed: 2000,
        responsive: [
            {
                breakpoint: 1024,
                settings: {
                    slidesToShow: 2,
                    slidesToScroll: 1,
                    dots: true,
                    arrows: false,
                }
            },
            {
                breakpoint: 768,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    dots: true
                }
            },
        ]
    });
}



$(document).ready(() => {
    const backToTop = $('#backToTop')
    const amountScrolled = 100

    $(window).scroll(() => {
        $(window).scrollTop() >= amountScrolled
            ? backToTop.fadeIn('fast')
            : backToTop.fadeOut('fast')
    })

    backToTop.click(() => {
        $('body, html').animate({
            scrollTop: 0
        }, 600)
        return false
    })
})

$(window).scroll(function () {
    var scrolled_val = $(document).scrollTop().valueOf();
    var header_nav = $(".header-nav");
    if (scrolled_val > 30) {
        if (!header_nav.hasClass('transTop'))
            header_nav.addClass('transTop');
    } else {
        if (header_nav.hasClass('transTop'))
            header_nav.removeClass('transTop');
    }
});

$('.burger-menu, .close-burger').on('click', () => {
    $(".mobile-navbar").toggleClass("mobile-translate");
    $("body").toggleClass("overflow-hidden");
})

function searchFunction() {
    var filter = $("#postSearchInput").val().toUpperCase();

    $("#postList a").each(function() {
        var txtValue = $(this).text().toUpperCase();
        if (txtValue.indexOf(filter) > -1) {
            $(this).css("display", "");
        } else {
            $(this).css("display", "none");
        }
    });

    $("article.post").each(function() {
        var title = $(this).find(".post-title a").text().toUpperCase();
        if (title.indexOf(filter) > -1) {
            $(this).css("display", "");
        } else {
            $(this).css("display", "none");
        }
    });
}
