<?php

namespace Visiosoft\RasyonelTheme;

use Anomaly\PostsModule\Post\PostRepository;
use Anomaly\PostsModule\Category\CategoryRepository;
use Anomaly\Streams\Platform\Addon\Plugin\Plugin;

class RasyonelThemePlugin extends Plugin
{
    protected $postRepository;
    protected $categoryRepository;

    public function __construct(PostRepository $postRepository, CategoryRepository $categoryRepository)
    {
        $this->postRepository = $postRepository;
        $this->categoryRepository = $categoryRepository;
    }

    public function getFunctions(): array
    {
        return [
            new \Twig_SimpleFunction(
                'getPostsByCategoryIDs',
                function ($category_ids, $limits = []) {
                    $allPosts = collect();

                    foreach ($category_ids as $index => $category_id) {
                        $limit = $limits[$index] ?? 6;

                        $posts = $this->postRepository->newQuery()->with('type')->where('category_id', $category_id)->limit($limit)->get();
                        $allPosts = $allPosts->concat($posts);
                    }

                    return $allPosts;
                }
            ),
            new \Twig_SimpleFunction(
                'getCatBySlug',
                function ($slug) {
                    return $this->categoryRepository->newQuery()->where('slug', $slug)->first();
                }
            ),
        ];
    }
}
