<?php namespace Visiosoft\RangeFieldType;

use Anomaly\Streams\Platform\Addon\FieldType\FieldType;

class RangeFieldType extends FieldType
{

    /**
     * The input view.
     *
     * @var null
     */
    protected $inputView = 'anomaly.field_type.integer::input';

    /**
     * Base field type rules.
     *
     * @var array
     */
    protected $rules = [
        'integer',
    ];

    /**
     * The database column type.
     *
     * @var string
     */
    protected $columnType = 'integer';

    /**
     * The field type config.
     *
     * @var array
     */
    protected $config = [
        'min'       => 0,
        'step'      => 1,
        'separator' => ',',
    ];

    /**
     * The request object.
     *
     * @var Request
     */

    /**
     * Get the rules.
     *
     * @return array
     */
    public function getRules()
    {
        $rules = parent::getRules();

        if ($min = array_get($this->config, 'min')) {
            $rules[] = 'min:' . $min;
        }

        if ($max = array_get($this->config, 'max')) {
            $rules[] = 'max:' . $max;
        }

        return $rules;
    }
}
