<?php namespace Visiosoft\QrcontactModule\Qr;


use Anomaly\UsersModule\User\UserModel;
use Visiosoft\ProfileModule\Profile\ProfileModel;

class QrModel
{

    public function source($adv)
    {
        $profile = new ProfileModel();
        $users = new UserModel();

        $user = $users->find($adv->created_by_id);

        $profile = $profile->getProfile($adv->created_by_id)->first();
        if($profile == null)
        {
            return null;
        }

        $qrSRC = "https://chart.googleapis.com/chart?cht=qr&"
            . "chs=350x350&chld=L&choe=UTF-8&"
            . "chl=BEGIN%3AVCARD%0AVERSION%3A3.0%0AN%3A"
            . urlencode($user->display_name)    //name
            . "%0AORG%3A"
            . urlencode(config('app.name'))//company
            . "%0ATITLE%3A"
            . urlencode($adv->name)  //ad name
            . "%0ATEL%3A"
            . urlencode($profile->gsm_phone)    //phone number
            . "%0AURL%3A"
            . urlencode(url()->current())       //url
            . "%0AEMAIL%3A"
            . urlencode($user->email)           //email
            . "%0AEND%3AVCARD";

        return $qrSRC;
    }
}
