<?php namespace Visiosoft\PushnotificationsModule\Template;

use Visiosoft\PushnotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class TemplateRepository extends EntryRepository implements TemplateRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var TemplateModel
     */
    protected $model;

    /**
     * Create a new TemplateRepository instance.
     *
     * @param TemplateModel $model
     */
    public function __construct(TemplateModel $model)
    {
        $this->model = $model;
    }

    /**
     * Get template by slug from database
     *
     * @param string $slug Template slug to find
     */
    public function getTemplateBySlug(string $slug)
    {
        return $this->model->newQuery()->where('slug', $slug)->first();
    }
}
