<?php namespace Visiosoft\PushnotificationsModule;

use Anomaly\Streams\Platform\Addon\AddonCollection;
use Anomaly\Streams\Platform\Addon\AddonIntegrator;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\PushnotificationsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\PushnotificationsModule\Template\TemplateRepository;
use Anomaly\Streams\Platform\Model\Pushnotifications\PushnotificationsTemplateEntryModel;
use Visiosoft\PushnotificationsModule\Template\TemplateModel;
use Visiosoft\PushnotificationsModule\Notification\Contract\NotificationRepositoryInterface;
use Visiosoft\PushnotificationsModule\Notification\NotificationRepository;
use Anomaly\Streams\Platform\Model\Pushnotifications\PushnotificationsNotificationEntryModel;
use Visiosoft\PushnotificationsModule\Notification\NotificationModel;
use Illuminate\Routing\Router;

class PushnotificationsModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/pushnotifications/template' => 'Visiosoft\PushnotificationsModule\Http\Controller\Admin\TemplateController@index',
        'admin/pushnotifications/template/create' => 'Visiosoft\PushnotificationsModule\Http\Controller\Admin\TemplateController@create',
        'admin/pushnotifications/template/edit/{id}' => 'Visiosoft\PushnotificationsModule\Http\Controller\Admin\TemplateController@edit',
        'admin/pushnotifications' => 'Visiosoft\PushnotificationsModule\Http\Controller\Admin\NotificationController@index',
        'admin/pushnotifications/create' => 'Visiosoft\PushnotificationsModule\Http\Controller\Admin\NotificationController@create',
        'admin/pushnotifications/edit/{id}' => 'Visiosoft\PushnotificationsModule\Http\Controller\Admin\NotificationController@edit',
        '/push_notifications/get-push-notifications/{limit?}' => [
            'as' => 'visiosoft.module.pushnotifications::get_push_notifications_datatable',
            'uses' => 'Visiosoft\PushnotificationsModule\Http\Controller\Admin\ApiController@pushNotificationLogsDatatable',
        ],
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\PushnotificationsModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\PushnotificationsModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\PushnotificationsModule\Event\ExampleEvent::class => [
        //    Visiosoft\PushnotificationsModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\PushnotificationsModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        PushnotificationsTemplateEntryModel::class => TemplateModel::class,
        PushnotificationsNotificationEntryModel::class => NotificationModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        TemplateRepositoryInterface::class => TemplateRepository::class,
        NotificationRepositoryInterface::class => NotificationRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register(AddonIntegrator $integrator, AddonCollection $addons)
    {
        $addon = $integrator->register(
            realpath(__DIR__ . '/../addons/visiosoft/push_notification_log_widget-extension/'),
            'visiosoft.extension.push_notification_log_widget',
            true,
            true
        );

        $addons->push($addon);
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
