<?php

namespace Visiosoft\PushnotificationsModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\PushnotificationsModule\Notification\Contract\NotificationRepositoryInterface;
use Yajra\DataTables\DataTables;

class ApiController extends AdminController
{
    public function pushNotificationLogsDatatable($limit)
    {
        $pushNotificationRepository = app(NotificationRepositoryInterface::class);
        $formatted = [];
        $notifications = $pushNotificationRepository->getNotifications(null, null, $limit);

        foreach ($notifications as $notification) {
            $formatted[] =
                [
                    'user' => $notification->user->getDisplayInfo(),
                    'notification' => $notification->template->name,
                    'status' => $notification->status ? "success" : "failed"
                ];
        }

        return DataTables::of($formatted)->toJson();
    }

}