<?php namespace Visiosoft\PushnotificationsModule\Notification;

use Visiosoft\PushnotificationsModule\Notification\Contract\NotificationRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class NotificationRepository extends EntryRepository implements NotificationRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var NotificationModel
     */
    protected $model;

    /**
     * Create a new NotificationRepository instance.
     *
     * @param NotificationModel $model
     */
    public function __construct(NotificationModel $model)
    {
        $this->model = $model;
    }

    /**
     * Create a new notification. This method is used to save notification data in database table.
     *
     * @param $data array of notification data to be saved in database table
     */
    public function createNotification($data)
    {
        return $this->create($data);
    }
}
