<?php namespace Visiosoft\PushnotificationsModule;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use \Visiosoft\PushnotificationsModule\Template\Contract\TemplateRepositoryInterface;

class PushnotificationsModuleSeeder extends Seeder
{

    public function run(TemplateRepositoryInterface $templateRepository)
    {
        $entries = [
            [
                'slug' => 'ticket_answered',
                'enabled' => true,
                'en' => [
                    'name' => 'Ticket answered',
                    'title' => 'Your ticket answered',
                    'message' => 'Your ticket answered',
                ],
                'tr' => [
                    'name' => 'Ticket answered',
                    'title' => 'Your ticket answered',
                    'message' => 'Your ticket answered',
                ],
            ]
        ];

        foreach ($entries as $entry) {
            if (!$templateRepository->newQuery()->where('slug', $entry['slug'])->orderBy('id')->first()) {
                $templateRepository->create($entry);
            }
        }
    }
}