<?php

namespace Visiosoft\PushnotificationsModule\Helpers;

class NotificationSendResponse
{
    private bool $responseStatus;
    private ?string $responseMessage;
    private ?int $responseHttpCode;

    public function __construct($responseStatus = true, $responseMessage = null, $responseHttpCode = null)
    {
        $this->responseStatus = $responseStatus;
        $this->responseMessage = $responseMessage;
        $this->responseHttpCode = $responseHttpCode;
    }

    public function getResponseStatus()
    {
        return $this->responseStatus;
    }

    public function getResponseMessage()
    {
        return $this->responseMessage;
    }

    public function getResponseHttpCode()
    {
        return $this->responseHttpCode;
    }

    public function getResponseJSON(): object
    {
        return (object)['status' => $this->getResponseStatus(), 'message' => $this->getResponseMessage(), 'httpCode' => $this->getResponseHttpCode()];
    }

}