<?php namespace Visiosoft\PushnotificationsModule\Notification\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

class NotificationFormBuilder extends FormBuilder
{

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $handler = NotificationFormHandler::class; // Assumes @handle

    protected $fields = [
        'title' => [
            'required' => true,
            'label' => 'visiosoft.module.pushnotifications::field.title.name',
            'type' => 'anomaly.field_type.text',
        ],
        'message' => [
            'required' => true,
            'label' => 'visiosoft.module.pushnotifications::field.message.name',
            'type' => 'anomaly.field_type.text',
        ],
        'url' => [
            'required' => true,
            'label' => 'visiosoft.module.pushnotifications::field.message.name',
            'type' => 'anomaly.field_type.text',
        ],
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [
        'save'
    ];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'redirect' => '/admin/pushnotifications',
        'success_message'   => 'visiosoft.module.pushnotifications::field.success.message',
    ];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [];

}
