<?php namespace Visiosoft\PushnotificationsModule\Notification;

use Visiosoft\PushnotificationsModule\Notification\Contract\NotificationRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class NotificationRepository extends EntryRepository implements NotificationRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var NotificationModel
     */
    protected $model;

    /**
     * Create a new NotificationRepository instance.
     *
     * @param NotificationModel $model
     */
    public function __construct(NotificationModel $model)
    {
        $this->model = $model;
    }

    /**
     * Create a new notification. This method is used to save notification data in database table.
     *
     * @param $data array of notification data to be saved in database table
     */
    public function createNotification($data)
    {
        $defaultCostumer = setting_value('visiosoft.module.vehicle::default_customer');
        if ($data['user_id'] != $defaultCostumer) {
            return $this->create($data);
        }
        return [];
    }

    public function getLastLogByTemplateAndUser($templateId, $users, $logId = null)
    {
        $log = $this->newQuery()->where('template_id', $templateId)
            ->whereIn('user_id', $users)
            ->orderBy('created_at', 'DESC');
        if (!empty($logId)) {
            $log = $log->whereNotIn('id', [$logId]);
        }
        return $log->first();
    }
}
