<?php namespace Visiosoft\PushnotificationsModule\Notification\Command;

class CreateNotification
{
    protected $title;
    protected $message;

    public function __construct($title, $message)
    {
        $this->title = $title;
        $this->message = $message;
    }

    public function handle()
    {
        $api_key = env('PUSH_API_KEY');
        $app_id = env('PUSH_APP_ID');

        if (!$api_key || !$app_id) {
            throw new \Exception("PUSH_API_KEY or PUSH_APP_ID not found in .env",500);
            die;
        }

        $fields = array(
            'app_id' => $app_id,
            'included_segments' => array(
                'Subscribed Users'
            ),
            'contents' => [
                "en" => $this->message
            ],
            'headings' => [
                "en" => $this->message
            ],
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json; charset=utf-8',
            'Authorization: Basic ' . $api_key
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

        $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        $response = curl_exec($ch);

        if ($http_status !== 200) {
            throw new \Exception($response);
            die;
        }

        curl_close($ch);

        return true;
    }
}
