<?php namespace Visiosoft\PushnotificationsModule\Notification\Form;


use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;

class NotificationFormHandler
{
    public function handle(NotificationFormBuilder $builder,SettingRepositoryInterface $settingRepository) {

        if (!$builder->canSave()) {
            return;
        }
        $request = $builder->getPostData();

        $content      = array(
            "en" => $request['message']
        );
        $headings      = array(
            "en" => $request['title']
        );
        $hashes_array = array();
        array_push($hashes_array, array(
            "id" => "like-button-2",
            "text" => "View Site",
            "url" => $request['url']
        ));
        $fields = array(
            'app_id' => $settingRepository->value('visiosoft.module.pushnotifications::appId'),
            'included_segments' => array(
                'All'
            ),
            'contents' => $content,
            'headings' => $headings,
            'web_buttons' => $hashes_array
        );

        $fields = json_encode($fields);
        print("\nJSON sent:\n");
        print($fields);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json; charset=utf-8',
            'Authorization: Basic '.$settingRepository->value('visiosoft.module.pushnotifications::apiKey')
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

        $response = curl_exec($ch);
        curl_close($ch);
        $builder->saveForm();

    }
}
