<?php namespace Visiosoft\PushnotificationsModule;

use Anomaly\Streams\Platform\Addon\Module\Module;

class PushnotificationsModule extends Module
{

    /**
     * The navigation display flag.
     *
     * @var bool
     */
    protected $navigation = true;

    /**
     * The addon icon.
     *
     * @var string
     */
    protected $icon = 'fa fa-puzzle-piece';

    /**
     * The module sections.
     *
     * @var array
     */
    protected $sections = [
        'notification' => [
            'buttons' => [
                'new_notification',
            ],
        ],
    ];

    public function send(array $title = [], array $message = [], array $user_ids = [])
    {
        $api_key = setting_value('visiosoft.module.pushnotifications::apiKey');
        $app_id = setting_value('visiosoft.module.pushnotifications::appId');

        $fields = [
            'app_id' => $app_id,
        ];

        if (count($title) > 0) {
            $fields['headings'] = $title;
        }

        if (count($message) > 0) {
            $fields['contents'] = $message;
        }

        if (count($user_ids) > 0) {
            $fields['include_external_user_ids'] = $user_ids;
            $fields['channel_for_external_user_ids'] = "push";
        } else {
            $fields['included_segments'] = ['All'];
        }

        $fields = json_encode($fields);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json; charset=utf-8',
            'Authorization: Basic ' . $api_key
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

        $response = json_decode(curl_exec($ch), true);
        curl_close($ch);

        if (isset($response->errors)) {
            throw new \Exception($response->errors[0], 500);
        }

        return true;
    }
}
