<?php namespace Visiosoft\PushnotificationsModule;

use Anomaly\Streams\Platform\Addon\Module\Module;

class PushnotificationsModule extends Module
{

    /**
     * The navigation display flag.
     *
     * @var bool
     */
    protected $navigation = true;

    /**
     * The addon icon.
     *
     * @var string
     */
    protected $icon = 'fa fa-puzzle-piece';

    /**
     * The module sections.
     *
     * @var array
     */
    protected $sections = [
        'notification' => [],
        'template' => [
            'buttons' => [
                'new_template',
            ],
        ],
    ];

    public function send(array $contents, array $userIds = [])
    {
        $apiKey = setting_value('visiosoft.module.pushnotifications::apiKey');
        $appId = setting_value('visiosoft.module.pushnotifications::appId');

        $fields['app_id'] = $appId;
        $fields['contents'] = $contents['messages'];

        if (!empty($contents['titles'])) {
            $fields['headings'] = $contents['titles'];
        }

        if (!empty($userIds)) {
            $fields['include_external_user_ids'] = $userIds;
            $fields['channel_for_external_user_ids'] = "push";
        } else {
            $fields['included_segments'] = ['All'];
        }

        $fields = json_encode($fields);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json; charset=utf-8',
            'Authorization: Basic ' . $apiKey
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

        $response = json_decode(curl_exec($ch), true);
        curl_close($ch);

        if (isset($response->errors)) {
            throw new \Exception($response->errors[0], 500);
        }

        return true;
    }
}
