<?php namespace Visiosoft\PushnotificationsModule\Notification\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class NotificationTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [
        'title', 'user'
    ];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'title',
        'user',
        'created_at' => [
            'wrapper' => '<strong>{value.datetime}</strong><br><small>{value.timeago}</small>',
            'value' => [
                'datetime' => 'entry.created_at_datetime',
                'timeago' => 'entry.created_at.diffForHumans()',
            ],
        ]
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
        'order_by' => ['created_at' => 'DESC'],
    ];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
