<?php

namespace Visiosoft\PushnotificationsModule\Notification\Command;

use Visiosoft\PushnotificationsModule\Contract\PushNotificationInterface;
use Visiosoft\PushnotificationsModule\Helpers\ClientTokens;
use Visiosoft\PushnotificationsModule\Helpers\NotificationContents;
use Visiosoft\PushnotificationsModule\Helpers\NotificationSendResponse;

class PushNotification implements PushNotificationInterface
{

    public function send(NotificationContents $contents, ClientTokens $clientTokens): NotificationSendResponse
    {
        $extensions = app('extension.collection')->installed();
        $defaultProvider = setting_value('visiosoft.module.pushnotifications::default_provider');
        $extension = $extensions->get($defaultProvider);

        if (!$extension) {
            return new NotificationSendResponse(false, 'Extension Not Found');
        }

        return $extension->send($contents, $clientTokens);
    }
}
