<?php namespace Visiosoft\PushnotificationsModule\Template\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Visiosoft\PushnotificationsModule\Template\Table\Handler\Disable;
use Visiosoft\PushnotificationsModule\Template\Table\Handler\Enable;

class TemplateTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [
        'enabled'
    ];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'enabled' => [
            'heading' => '',
            'class' => 'text-center',
            'wrapper' => '{value.enabled}',
            'value' => [
                'enabled' => '<span class="tag tag-{{entry.enabled ? "success" : "danger"}} tag-sm">{{trans("visiosoft.module.pushnotifications::field." ~ (entry.enabled ? "enabled" : "disabled") ~ ".name")}}</span>',
            ],
        ],
        'name' => [
            'value' => 'entry.name',
            'class' => 'w-100'
        ],
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'edit'
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'disable' => [
            'icon' => 'fa fa-times-circle',
            'handler' => Disable::class,
            'class' => 'btn btn-danger',
        ],
        'enable' => [
            'icon' => 'fa fa-check-circle',
            'handler' => Enable::class,
            'class' => 'btn btn-success',
        ],
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
