<?php namespace Visiosoft\PushnotificationsModule\Notification\Form;

class NotificationFormHandler
{
    public function handle(NotificationFormBuilder $builder) {

        if (!$builder->canSave()) {
            return;
        }
        $request = $builder->getPostData();

        $api_key = setting_value('visiosoft.module.pushnotifications::apiKey');
        $app_id = setting_value('visiosoft.module.pushnotifications::appId');

        if (!$api_key || !$app_id) {
            throw new \Exception("PUSH_API_KEY or PUSH_APP_ID not found in .env",500);
            die;
        }

        $content      = array(
            "en" => $request['message']
        );
        $headings      = array(
            "en" => $request['title']
        );
        $hashes_array = array();
        array_push($hashes_array, array(
            "id" => "like-button-2",
            "text" => "View Site",
            "url" => $request['url']
        ));
        $fields = array(
            'app_id' => $app_id,
            'included_segments' => array(
                'All'
            ),
            'contents' => $content,
            'headings' => $headings,
            'web_buttons' => $hashes_array
        );

        $fields = json_encode($fields);
        print("\nJSON sent:\n");
        print($fields);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json; charset=utf-8',
            'Authorization: Basic '.$api_key
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

        $response = curl_exec($ch);
        curl_close($ch);
        $builder->saveForm();

    }
}
