<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModulePushnotificationsCreateTemplateStream extends Migration
{
    protected $delete = false;

    protected $stream = [
        'slug' => 'template',
        'title_column' => 'name',
        'translatable' => true,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        'name' => 'anomaly.field_type.text',
        'slug' => [
            'type' => 'anomaly.field_type.slug',
            'config' => [
                'slugify' => 'name',
                'type' => '_'
            ],
        ],
        'enabled' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => true,
            ],
        ],
        'url' => [
            'type' => 'anomaly.field_type.url',
            'config' => [
                'default_value' => 'https://',
            ],
        ],
    ];

    protected $assignments = [
        'enabled' => [
            'required' => false,
        ],
        'name' => [
            'translatable' => true,
            'required' => true,
        ],
        'slug' => [
            'unique' => true,
            'required' => true,
        ],
        'title' => [
            'translatable' => true,
            'required' => false,
        ],
        'message' => [
            'translatable' => true,
            'required' => true,
        ],
        'url' => [
            'required' => false,
        ],
    ];
}
