<?php namespace Visiosoft\PushnotificationsModule\Notification\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

class NotificationFormBuilder extends FormBuilder
{
    protected $handler = NotificationFormHandler::class; // Assumes @handle

    protected $fields = [
        'title' => [
            'required' => true,
            'label' => 'visiosoft.module.pushnotifications::field.title.name',
            'type' => 'anomaly.field_type.text',
        ],
        'message' => [
            'required' => true,
            'label' => 'visiosoft.module.pushnotifications::field.message.name',
            'type' => 'anomaly.field_type.text',
        ],
        'url' => [
            'required' => true,
            'label' => 'visiosoft.module.pushnotifications::field.message.name',
            'type' => 'anomaly.field_type.text',
        ],
    ];

    protected $actions = [
        'save'
    ];

    protected $buttons = [
        'cancel',
    ];

    protected $options = [
        'redirect' => '/admin/pushnotifications',
        'success_message'   => 'visiosoft.module.pushnotifications::field.success.message',
    ];
}
