<?php namespace Visiosoft\PricehistoryModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\AdvsModule\Adv\Event\PriceChange;
use Visiosoft\PricehistoryModule\History\Contract\HistoryRepositoryInterface;
use Visiosoft\PricehistoryModule\History\HistoryRepository;
use Anomaly\Streams\Platform\Model\Pricehistory\PricehistoryHistoryEntryModel;
use Visiosoft\PricehistoryModule\History\HistoryModel;
use Visiosoft\PricehistoryModule\History\Listener\PriceLog;

class PricehistoryModuleServiceProvider extends AddonServiceProvider
{
    protected $routes = [
        'admin/pricehistory'           => 'Visiosoft\PricehistoryModule\Http\Controller\Admin\HistoryController@index',
        'admin/pricehistory/create'    => 'Visiosoft\PricehistoryModule\Http\Controller\Admin\HistoryController@create',
        'admin/pricehistory/edit/{id}' => 'Visiosoft\PricehistoryModule\Http\Controller\Admin\HistoryController@edit',

        // Admin ReportController
        'admin/api/pricehistory/report/price' => 'Visiosoft\PricehistoryModule\Http\Controller\Admin\ReportController@price',
    ];

    protected $listeners = [
        PriceChange::class => [
            PriceLog::class,
        ],
    ];

    protected $bindings = [
        PricehistoryHistoryEntryModel::class => HistoryModel::class,
    ];

    protected $singletons = [
        HistoryRepositoryInterface::class => HistoryRepository::class,
    ];
}
