<?php namespace Visiosoft\PricehistoryModule\History;

use Visiosoft\PricehistoryModule\History\Contract\HistoryRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class HistoryRepository extends EntryRepository implements HistoryRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var HistoryModel
     */
    protected $model;

    /**
     * Create a new HistoryRepository instance.
     *
     * @param HistoryModel $model
     */
    public function __construct(HistoryModel $model)
    {
        $this->model = $model;
    }

    public function changePriceReport()
    {
        $histories = $this->newQuery()
            ->selectRaw('
                adv_id as classified_id,
                (SELECT price FROM default_pricehistory_history WHERE adv_id = classified_id ORDER BY created_at ASC LIMIT 1) as initial,
                (SELECT price FROM default_pricehistory_history WHERE adv_id = classified_id ORDER BY created_at DESC LIMIT 1) as latest,
                name as product
            ')
            ->groupBy('adv_id')
            ->leftJoin('advs_advs_translations as classified_trans', function ($join) {
                $join->on('pricehistory_history.adv_id', '=', 'classified_trans.entry_id');
                $join->whereIn('locale', [config('app.locale'), setting_value('streams::default_locale'), 'en']);
            });

        if ($search = request('search.value')) {
            $histories = $histories->where('name', 'LIKE', "%$search%");
        }

        if ($orderDir = request('order.0.dir')) {
            $histories = $histories->orderBy('product', $orderDir);
        }

        $start = request('start');
        $limit = request('length') ?: 10;
        $page = $start ? $start / $limit + 1 : 1;

        return $histories->paginate($limit, ['*'], 'page', $page);
    }
}
