$(document).ready( function () {
    $('#priceDropReport').DataTable({
        ajax: {
            url: '/admin/api/pricehistory/report/price',
            dataSrc( json ) {
                json.recordsTotal = json.total;
                json.recordsFiltered = json.total;

                return json.data;
            }
        },
        processing: true,
        serverSide: true,
        columns: [
            {
                data: 'product',
                render: function ( data, type, row, meta ) {
                    return `
                        <a href="/ad/${row.classified_id}" class="text-info">
                            ${data ? data : priceDropReportTrans.undefined_product}
                        </a>
                    `;
                }
            },
            { data: 'initial', orderable: false },
            { data: 'latest', orderable: false },
        ],
    });
} );
