<?php namespace Visiosoft\PricehistoryModule\History;

use Visiosoft\PricehistoryModule\History\Contract\HistoryInterface;
use Anomaly\Streams\Platform\Model\Pricehistory\PricehistoryHistoryEntryModel;

class HistoryModel extends PricehistoryHistoryEntryModel implements HistoryInterface
{
    public function newPrice($adv)
    {
        $old = $this->changeStatus($adv);
        if ($old != null) {
            $difference = intval($adv['price']) - intval($old->price);
            $percent = $difference * 100 / intval($old->price);
            if ($difference < 0) {
                $color = "danger";
            } else {
                $color = "success";
            }
            $this->create([
                'adv_id' => $adv['id'],
                'price' => $adv['price'],
                'currency' => $adv['currency'],
                'status' => "now",
                'difference' => $difference,
                'percent' => intval(round($percent, 0)),
                'color' => $color,
            ]);
        }
    }

    public function changeStatus($adv)
    {
        $old = $this->where('adv_id', $adv['id'])->orderByDesc('id')->first();
        if ($old != null and $adv['price'] != $old->price) {
            $old->update(['status' => 'old']);
            return $old;
        }
        if ($old == null) {
            $this->create([
                'adv_id' => $adv['id'],
                'price' => $adv['price'],
                'currency' => $adv['currency'],
                'status' => "now",
            ]);
        }
        return null;
    }
}
