<?php namespace Visiosoft\PricehistoryModule\History\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class HistoryTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'adv',
        'price' => [
            'value' => 'entry.price ~ " " ~ entry.currency',
        ],
        'difference' => [
            'value' => '<font class="text-{entry.color}">{entry.difference}</font>'
        ],
        'percent' => [
            'value' => '<font class="text-{entry.color}">{entry.percent}%</font>'
        ],
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
        'order_by' => [
            'id' => 'DESC',
        ],
    ];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
