<?php

return [
    'client_id'         => [
        'required' => true,
        'env'      => 'PINTEREST_CLIENT_ID',
        'bind'     => 'services.pinterest.client_id',
        'type'     => 'anomaly.field_type.encrypted',
    ],
    'client_secret'     => [
        'required' => true,
        'env'      => 'PINTEREST_CLIENT_SECRET',
        'bind'     => 'services.pinterest.client_secret',
        'type'     => 'anomaly.field_type.encrypted',
    ],
    'scope'             => [
        'bind'   => 'services.pinterest.scope',
        'type'   => 'anomaly.field_type.tags',
        'config' => [
            'default_value' => [
                'email',
                'public_profile',
            ],
        ],
    ],
    'application_scope' => [
        'bind'   => 'services.pinterest.application_scope',
        'type'   => 'anomaly.field_type.tags',
        'config' => [
            'default_value' => [
                'email',
                'public_profile',
                'publish_actions',
            ],
        ],
    ],
];
