<?php namespace Visiosoft\PhoneclickcounterModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\AdvsModule\Adv\Event\showAdPhone;
use Visiosoft\PhoneclickcounterModule\Counter\Contract\CounterRepositoryInterface;
use Visiosoft\PhoneclickcounterModule\Counter\CounterRepository;
use Anomaly\Streams\Platform\Model\Phoneclickcounter\PhoneclickcounterCounterEntryModel;
use Visiosoft\PhoneclickcounterModule\Counter\CounterModel;
use Visiosoft\PhoneclickcounterModule\Counter\Listener\PhoneClickLog;
use Illuminate\Routing\Router;

class PhoneclickcounterModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/phoneclickcounter'           => 'Visiosoft\PhoneclickcounterModule\Http\Controller\Admin\CounterController@index',
        'admin/phoneclickcounter/create'    => 'Visiosoft\PhoneclickcounterModule\Http\Controller\Admin\CounterController@create',
        'admin/phoneclickcounter/edit/{id}' => 'Visiosoft\PhoneclickcounterModule\Http\Controller\Admin\CounterController@edit',

        'api/countPhone' => [
            'as' => 'visiosoft.module.phoneclickcounter::count_show_phone',
            'uses' => 'Visiosoft\PhoneclickcounterModule\Http\Controller\CounterController@showPhoneCounter',
        ],
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\PhoneclickcounterModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\PhoneclickcounterModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        showAdPhone::class => [
            PhoneClickLog::class,
        ],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\PhoneclickcounterModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        PhoneclickcounterCounterEntryModel::class => CounterModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        CounterRepositoryInterface::class => CounterRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
