<?php namespace Visiosoft\PhoneclickcounterModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\PhoneclickcounterModule\Counter\Contract\CounterRepositoryInterface;

class CounterController extends PublicController
{
    protected $repository;

    public function __construct(CounterRepositoryInterface $repository)
    {
        $this->repository = $repository;
        parent::__construct();
    }

    public function showPhoneCounter()
    {
        $response = [
            'status' => false,
            'message' => ''
        ];

        if (request()->has('id')) {
            try {
                $this->repository->newCounterRecord(request('id'));
                $response['status'] = true;
            } catch (\Exception $exception) {
                $response['message'] = $exception->getMessage();
            }
        }

        return $this->response->json($response);
    }
}
