<?php namespace Visiosoft\PhoneclickcounterModule\Counter;

use Illuminate\Support\Facades\Auth;
use Visiosoft\PhoneclickcounterModule\Counter\Contract\CounterRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class CounterRepository extends EntryRepository implements CounterRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var CounterModel
     */
    protected $model;

    /**
     * Create a new CounterRepository instance.
     *
     * @param CounterModel $model
     */
    public function __construct(CounterModel $model)
    {
        $this->model = $model;
    }

    public function newCounterRecord($id)
    {
        return $this->newQuery()->create([
            'adv_id' => $id,
            'user_type' => (Auth::check()) ? 'user' : 'guest',
            'user_id' => Auth::id(),
            'ip_address' => request()->ip(),
        ]);
    }
}
