<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Anomaly\UsersModule\User\UserModel;
use Visiosoft\AdvsModule\Adv\AdvModel;

class VisiosoftModulePhoneclickcounterCreatePhoneclickcounterFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'adv' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => AdvModel::class
            ]
        ],
        'user_type' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                'options' => ['user' => 'User', 'guest' => 'Guest'],
                'separator' => ':',
            ]
        ],
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'mode' => 'lookup',
                'related' => UserModel::class,
            ],
        ],
        'ip_address' => 'anomaly.field_type.text',
    ];

}
