<?php namespace Visiosoft\PhoneclickcounterModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\AdvsModule\Adv\Event\showAdPhone;
use Visiosoft\PhoneclickcounterModule\Counter\Contract\CounterRepositoryInterface;
use Visiosoft\PhoneclickcounterModule\Counter\CounterRepository;
use Anomaly\Streams\Platform\Model\Phoneclickcounter\PhoneclickcounterCounterEntryModel;
use Visiosoft\PhoneclickcounterModule\Counter\CounterModel;
use Visiosoft\PhoneclickcounterModule\Counter\Listener\PhoneClickLog;

class PhoneclickcounterModuleServiceProvider extends AddonServiceProvider
{
    protected $routes = [
        // Admin CounterController
        'admin/phoneclickcounter'           => 'Visiosoft\PhoneclickcounterModule\Http\Controller\Admin\CounterController@index',
        'admin/phoneclickcounter/create'    => 'Visiosoft\PhoneclickcounterModule\Http\Controller\Admin\CounterController@create',
        'admin/phoneclickcounter/edit/{id}' => 'Visiosoft\PhoneclickcounterModule\Http\Controller\Admin\CounterController@edit',

        // CounterController
        'api/countPhone' => [
            'as' => 'visiosoft.module.phoneclickcounter::count_show_phone',
            'uses' => 'Visiosoft\PhoneclickcounterModule\Http\Controller\CounterController@showPhoneCounter',
        ],
        'phone-clicks' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.phoneclickcounter::phone.clicks',
            'uses' => 'Visiosoft\PhoneclickcounterModule\Http\Controller\CounterController@index',
        ],
    ];

    protected $listeners = [
        showAdPhone::class => [
            PhoneClickLog::class,
        ],
    ];

    protected $bindings = [
        PhoneclickcounterCounterEntryModel::class => CounterModel::class,
    ];

    protected $singletons = [
        CounterRepositoryInterface::class => CounterRepository::class,
    ];
}
