<?php namespace Visiosoft\PhoneclickcounterModule\Counter;

use Anomaly\Streams\Platform\Entry\EntryCollection;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Visiosoft\PhoneclickcounterModule\Counter\Contract\CounterRepositoryInterface;

class CounterCollection extends EntryCollection
{
    public function getChartData()
    {
        $numberOfDays = setting_value('visiosoft.module.phoneclickcounter::for_the_past_days');
        $counterRepository = app(CounterRepositoryInterface::class);

        $clicksCount = $counterRepository
            ->newQuery()
            ->select([
                DB::raw('DATE(created_at) AS date'),
                DB::raw('COUNT(id) AS count'),
            ])
            ->whereIn('id', $this->pluck('id')->all())
            ->whereBetween('created_at', [Carbon::now()->subDays((int)$numberOfDays), Carbon::now()])
            ->groupBy('date')
            ->orderBy('date', 'ASC')
            ->pluck('count', 'date')
            ->all();

        $allDaysCount = array();
        $date = new Carbon;
        for ($i = 0; $i < $numberOfDays; $i++) {
            $dateString = $date->format('Y-m-d');
            if (!isset($clicksCount[$dateString])) {
                $allDaysCount[$dateString] = 0;
            } else {
                $allDaysCount[$dateString] = $clicksCount[$dateString];
            }
            $date->subDay();
        }

        $chartData = array();
        foreach ($allDaysCount as $date => $count) {
            $chartData[] = [$date, $count];
        }

        return $chartData;
    }
}
