<?php namespace Visiosoft\PetTheme;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\FavsModule\Favorite\Contract\FavoriteRepositoryInterface;

class PetThemeServiceProvider extends AddonServiceProvider
{
    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        'streams::errors/404' => 'visiosoft.theme.base::errors/404',
        'streams::errors/403' => 'visiosoft.theme.base::errors/403',
        'anomaly.module.users::login' => 'visiosoft.theme.base::addons/anomaly/users-module/login',
        'anomaly.module.users::register' => 'visiosoft.theme.base::addons/anomaly/users-module/register',
        'anomaly.module.users::password/forgot' => 'visiosoft.theme.base::addons/anomaly/users-module/password/forgot',
        'anomaly.module.users::password/reset' => 'visiosoft.theme.base::addons/anomaly/users-module/password/reset',
    ];

    protected $plugins = [
        PetThemePlugin::class
    ];

    protected $routes = [
        'ajax/getFeatures/{typeId}/{catId}'  => [
            'as' => 'getFeatures',
            'uses' => 'Visiosoft\PetTheme\Http\Controller\PetThemeController@getFeatures'
        ],
        'ajax/get-advs-by-catId/{categoryID}/{level}' => [
            'as' => 'ajaxgetAdvsByCat',
            'uses' => 'Visiosoft\PetTheme\Http\Controller\PetThemeController@getAdvsByCat'
        ],
        'ajax/getCategories2' => 'Visiosoft\PetTheme\Http\Controller\PetThemeController@getCategories',
    ];

    public function boot(FavoriteRepositoryInterface $favoriteRepository)
    {
        view()->composer('visiosoft.theme.pet::index/*', function ($view) use ($favoriteRepository) {
            $favs = $favoriteRepository->getItems(auth()->id(), 'adv');

            $view->with('favs', $favs);
        });
    }
}
