<?php namespace Visiosoft\PetTheme\Seed;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\SettingsModule\Setting\SettingRepository;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;

class SettingSeed extends Seeder
{
    protected $categoryRepository;
    protected $settingRepository;

    public function __construct(SettingRepositoryInterface $settingRepository, CategoryRepositoryInterface $categoryRepository)
    {
        $this->categoryRepository = $categoryRepository;
        $this->settingRepository = $settingRepository;
    }

    public function run()
    {
        if ($category = $this->categoryRepository->findBySlug('pet_ads')) {
            $this->settingRepository->set('visiosoft.theme.pet::select_project_category', $category->getId());
        }
    }
}
