<?php namespace Visiosoft\PetTheme;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\CatsModule\Category\Command\getCategoriesLevel2;


class PetThemePlugin extends Plugin
{
    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'getSecondCategory',
                function () {
                    $cats = $this->dispatch(new getCategoriesLevel2());
                    if (count($cats->maincats) > 0) {
                       $maincats = $cats->maincats->where('id' , '!=' , setting_value('visiosoft.theme.pet::select_project_category'))->first()->id;
                       return $maincats;
                    }
                    return null;
                }
            ),

            new \Twig_SimpleFunction(
                'declineDoping',
                function ($slug) {
                    return in_array($slug, ['category_showcase', 'home_page_showcase', 'opportunity_products']) ? true : false;
                }
            ),
        ];
    }
}
