<?php

return [
    "header_primary_color" => [
        "type" => "anomaly.field_type.colorpicker",
        "config" => [
            "default_value" => '#3f475f',
        ]
    ],
    "enable_lazy_loading" => [
        "type" => "anomaly.field_type.boolean",
        "config" => [
            "default_value" => true,
            "mode" => 'checkbox',
        ]
    ],
    "header_secondary_color" => [
        "type" => "anomaly.field_type.colorpicker",
        "config" => [
            "default_value" => '#2f3546',
        ]
    ],
    "header_text_color" => [
        "type" => "anomaly.field_type.colorpicker",
        "config" => [
            "default_value" => '#EBEBEB',
        ]
    ],
    "mobile_header_text_color" => [
        "type" => "anomaly.field_type.colorpicker",
        "config" => [
            "default_value" => '#fff',
        ]
    ],
    "footer_primary_color" => [
        "type" => "anomaly.field_type.colorpicker",
        "config" => [
            "default_value" => '#f9f9f9',
        ]
    ],
    "footer_secondary_color" => [
        "type" => "anomaly.field_type.colorpicker",
        "config" => [
            "default_value" => '#fff',
        ]
    ],
    "ad_detail_color_scheme" => [
        "type" => "anomaly.field_type.colorpicker",
    ],
    'show_view_count' => [
        'type' => 'anomaly.field_type.boolean',
        "config" => [
            "default_value" => true,
            "mode" => 'checkbox',
        ]
    ],
    'home_ad_height' => [
        'type' => 'anomaly.field_type.integer',
        'warning' => "100px default",
        'config' => [
            'min' => 40,
            'default_value' => 100
        ],
    ],
    'logo_web' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'left_menu_side' => [
        'type' => 'anomaly.field_type.select',
        "config" => [
            "options" => [
                'left' => "visiosoft.theme.pet::setting.left.name",
                'right' => "visiosoft.theme.pet::setting.right.name",
            ],
            "default_value" => 'left',
            "mode" => "radio",
        ]
    ],
    'logo_mobile' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    "favicon" => [
        "type" => "anomaly.field_type.file",
        "config" => [
            "folders" => ['favicon'],
            "mode" => "upload",
        ]
    ],
    'help_phone' => [
        'type' => 'anomaly.field_type.text',
        "config" => [
            'type' => 'tel',
            'mask' => '0(999) 999-9999'
        ]
    ],
    'banner_web' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'banner_mobile' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'banner_link_new_tab' => [
        'type' => 'anomaly.field_type.boolean',
        "config" => [
            "default_value" => true,
        ]
    ],
    'show_banner' => [
        'type' => 'anomaly.field_type.boolean',
        "config" => [
            "default_value" => true,
        ]
    ],
    'warning_message' => [
        'type' => 'anomaly.field_type.textarea',
        "config" => [
            "default_value" => "The ad creator is solely responsible for the content, correctness, accuracy and legal obligation of all posted ads, entries, ideas and information. openclassify.com is not in any way responsible for the quality or legality of content created and posted by its users. You should contact the ad creator directly with your questions.",
        ]
    ],
    'facebook' => [
        'type' => 'anomaly.field_type.url',
        "config" => [
            'default_value' => '#',
        ]
    ],
    'twitter' => [
        'type' => 'anomaly.field_type.url',
        "config" => [
            'default_value' => '#',
        ]
    ],
    'linkedin' => [
        'type' => 'anomaly.field_type.url',
        "config" => [
            'default_value' => '#',
        ]
    ],
    'instagram' => [
        'type' => 'anomaly.field_type.url',
        "config" => [
            'default_value' => '#',
        ]
    ],
    'youtube' => [
        'type' => 'anomaly.field_type.url',
        "config" => [
            'default_value' => '#',
        ]
    ],
    'show_country' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => 0
        ],
    ],
    'default_owner' => [
        "type" => "anomaly.field_type.relationship",
        "config" => [
            "related" => '\Anomaly\UsersModule\User\UserModel',
            "mode" => "search",
            "default_value" => null,
        ]
    ],
    'show_owner_details' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => 1
        ],
    ],
    'security_tips_msg' => [
        'type' => 'anomaly.field_type.textarea',
        "config" => [
            "default_value" => "Don't make down-payment or send money before seeing the real-estate you want to buy.",
        ]
    ],
    'show_security_tips' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => 1
        ],
    ],
//    Advertising Area Start
    //for web
    'home_bottom_left_categories' => [
        'type' => 'anomaly.field_type.wysiwyg',
    ],
    'home_bottom' => [
        'type' => 'anomaly.field_type.wysiwyg',
    ],
    'home_top_latestAds' => [
        'type' => 'anomaly.field_type.wysiwyg',
    ],
    'home_bottom_latestAds' => [
        'type' => 'anomaly.field_type.wysiwyg',
    ],
    'detail_bottom' => [
        'type' => 'anomaly.field_type.wysiwyg',
    ],

    //for mobile
    'detail_bottom_mobile' => [
        'type' => 'anomaly.field_type.wysiwyg',
    ],
    'home_bottom_mobile' => [
        'type' => 'anomaly.field_type.wysiwyg',
    ],

//    Advertising Area Stop

    'banner_web_link' => [
        'type' => 'anomaly.field_type.url',
        'config' => [
            'default_value' => '#',
        ],
    ],
    'banner_mobile_link' => [
        'type' => 'anomaly.field_type.url',
        'config' => [
            'default_value' => '#',
        ],
    ],
    'home_page_sub_categories_limit' => [
        'type' => 'anomaly.field_type.integer',
        'config' => [
            'min' => 0,
            'default_value' => 8
        ],
    ],

    'playstore' => [
        'type' => 'anomaly.field_type.url',
        "config" => [
            'default_value' => '#',
        ]
    ],
    'appstore' => [
        'type' => 'anomaly.field_type.url',
        "config" => [
            'default_value' => '#',
        ]
    ],
    'shareWhatsappMsg' => [
        'type' => 'anomaly.field_type.textarea',
        "config" => [
            'default_value' => 'See what I found on Openclassify. Just look at the details.',
        ]
    ],
    'display_language_feature_with_flags' => 'anomaly.field_type.boolean',
    'show_subcategories_on_mobile_view' => 'anomaly.field_type.boolean',
    'contact_info_visible_to_login_user' => 'anomaly.field_type.boolean',
    'show_change_currency' => 'anomaly.field_type.boolean',
    'desktop_payment_band' => [
        'type' => 'anomaly.field_type.file',
        'config' => [
            'folders' => ['images']
        ]
    ],
    'mobile_payment_band' => [
        'type' => 'anomaly.field_type.file',
        'config' => [
            'folders' => ['images']
        ],
    ],
    'description_active' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
        ]
    ],
    'show_cart' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
        ]
    ],
    'contact_email' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'type' => 'email'
        ]
    ],
    'evcil_ilan_theme' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
        ]
    ],
    "select_project_category" => [
        "type" => "anomaly.field_type.select",
        "config" => [
            "options" => function (\Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface $categoryRepository) {
                return $categoryRepository->getMainCategories()->pluck('name', 'id')->all();
            },
        ],
    ],
    "evcil_ilan_web_cat" => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => true,
        ]
    ],
    "evcil_ilan_bookmarks" => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => true,
        ]
    ],
    "contact_page_id" => [
        'type' => 'anomaly.field_type.relationship',
        'config' => [
            'related' => \Anomaly\Streams\Platform\Model\Pages\PagesPagesEntryModel::class,
        ]
    ],
    'pet_top_banner' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'pet_bottom_banner' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'pet_top_header' => [
        'type' => 'anomaly.field_type.text',
        "config" => [
            'type' => 'text',
            'default_value' => 'Evcil Hayvan İlanları',
            'translatable' => true,
            'max' => 40
        ]
    ],
    'pet_bottom_header' => [
        'type' => 'anomaly.field_type.text',
        "config" => [
            'type' => 'text',
            'default_value' => 'Evcil Hayvan Ürünleri',
            'max' => 40
        ]
    ],
    'background_img' => [
        'type' => 'anomaly.field_type.file',
    ],
    'new_ad_sms' => [
        'type' => 'anomaly.field_type.boolean',
        "config" => [
            "default_value" => false,
        ]
    ],
    'terms_privacy_page' => [
        'type' => 'anomaly.field_type.select',
        'config' => [
            'handler' => \Visiosoft\PetTheme\Handler\PagesOptions::class,
        ]
    ],
    'show_ads' => [
        'type' => 'anomaly.field_type.boolean',
        "config" => [
            "default_value" => false,
        ]
    ],
    'pet_status_cf' => [
        "type" => "anomaly.field_type.relationship",
        "config" => [
            "related" => \Visiosoft\CustomfieldsModule\CustomField\CustomFieldModel::class,
            "mode" => "search",
        ]
    ],
    'use_cf_price' => [
        'type' => 'anomaly.field_type.boolean',
        "config" => [
            'default_value' => true
        ]
    ]
];
