// Change search mode script
$(".search-type").on("change", function () {
    $(".home-page-search-form").attr("action", this.value);
});

//Hidden Categories For Home
$(".show-all a").on("click", function () {
    if ($(this).hasClass("active-all-categories")) {
        var icon = "<i class='fas fa-arrow-circle-down'></i>";
        $(this).html(show_all_text + " " + icon);
        $(this).removeClass("active-all-categories");
        $(this)
            .parent("li")
            .parent("ul")
            .find(".hidden-category")
            .addClass("hidden");
    } else {
        var icon = "<i class='fas fa-arrow-circle-up'></i>";
        $(this).html(close_text + " " + icon);
        $(this).addClass("active-all-categories");
        $(this).parent("li").parent("ul").find("li").removeClass("hidden");
    }
});

$(".currency-filtering-label").on("click", function () {
    $('input[name="currency"]').val($(this).data("value"));
    $(".price-input").attr(
        "placeholder",
        $(".price-input").data("placeholder") + " " + $(this).data("value")
    );
});

// Restricts input for the given textbox to the given inputFilter function.
function setInputFilter(textbox, inputFilter) {
    if (textbox) {
        [
            "input",
            "keydown",
            "keyup",
            "mousedown",
            "mouseup",
            "select",
            "contextmenu",
            "drop",
        ].forEach(function (event) {
            textbox.addEventListener(event, function () {
                if (inputFilter(this.value)) {
                    this.oldValue = this.value;
                    this.oldSelectionStart = this.selectionStart;
                    this.oldSelectionEnd = this.selectionEnd;
                } else if (this.hasOwnProperty("oldValue")) {
                    this.value = this.oldValue;
                    this.setSelectionRange(this.oldSelectionStart, this.oldSelectionEnd);
                } else {
                    this.value = "";
                }
            });
        });
    }
}

setInputFilter(document.getElementById("min-filter"), function (value) {
    return /^\d*\.?\d*$/.test(value); // Allow digits and '.' only, using a RegExp
});

setInputFilter(document.getElementById("max-filter"), function (value) {
    return /^\d*\.?\d*$/.test(value); // Allow digits and '.' only, using a RegExp
});

$(".price-input").focus(function () {
    $(".price-filter-btn").removeClass("hidden");
});

$(".price-input").focusout(function () {
    var min = $("#min-filter").val();
    var max = $("#max-filter").val();
    if (max == "" && min == "") $(".price-filter-btn").addClass("hidden");
});

$(".search-nav-btn").on("click", function () {
    $(".navigation-first").addClass("d-none");
    $(".navigation-search").removeClass("d-none");
});

$(".close-search-nav").on("click", function () {
    $(".navigation-first").removeClass("d-none");
    $(".navigation-search").addClass("d-none");
});

if (
    /Android|webOS|iPhone|iPad|iPod|BlackBerry/i.test(navigator.userAgent) &&
    !descActive
) {
    $(
        ".description-info.classified-description .nav-tabs .nav-item.active"
    ).removeClass("active");
    $(
        ".description-info.classified-description .nav-tabs .nav-item:first-child"
    ).addClass("active");
    $(
        ".description-info.classified-description .tab-content .tab-pane.active"
    ).removeClass("active");
    $(
        ".description-info.classified-description .tab-content .tab-pane:first-child"
    ).addClass(["show", "active"]);
}
//changes for content of category modal
$("#showAds").on("click", function (e) {
    e.preventDefault();
    let mainPage = $("#mobileListingPageEI");
    let mainNav = $("#mobileNavPageEI");
    let eiFooter = $(".ei-footer");
    let categoryLink = $(".dynamic-cat-link");
    let adCategoryItem = $('.ad-category-item');
    let productCategoryItem = $('.product-category-item');
    let latestAdsFooterLi = $('.ads-cat-modal-li');
    let latestPrdFooterLi = $('.prd-cat-modal-li');
    sessionStorage.setItem('cat-content', 'ads');

    latestAdsFooterLi.removeClass('d-none');
    latestPrdFooterLi.addClass('d-none');

    productCategoryItem.addClass('d-none');
    adCategoryItem.removeClass('d-none');
    mainNav.addClass("d-none");
    eiFooter.addClass("d-flex");
    mainNav.attr('style','display:none !important');
    mainPage.removeClass("d-none");
    $('#footer').attr('style','display:block');
    $('.to-products-info').removeClass('d-none');
    window.scrollTo(0, 0);
});
//changes for content of category modal
$("#showCategories").on("click", function (e) {
    e.preventDefault();
    let categoryPage = $("#mobileCategoriesPageEI");
    let mainNav = $("#mobileNavPageEI");
    let categoryList = $(".ei-category-list").eq(1);
    let eiFooter = $(".ei-footer");
    let categoryLink = $(".dynamic-cat-link");
    let productCategoryItem = $('.product-category-item');
    sessionStorage.setItem('cat-content', 'prd');

    mainNav.addClass("d-none");
    eiFooter.removeClass("d-none");
    eiFooter.addClass("d-flex");
    mainNav.attr('style','display:none !important');
    categoryPage.removeClass("d-none");
    categoryList.removeClass("ei-sm-section");
    $('#footer').attr('style','display:block');
    $('.to-ads-info').removeClass('d-none');
    window.scrollTo(0, 0);
});

$(".dynamic-cat-link").on('click',function (e)
{
    $(".showable-cats").children('.ei-category-list').removeClass('ei-sm-section')
})

//Session item setting for category modal content
$(".ads-see-all").on("click", function (e) {
    sessionStorage.setItem('cat-content', 'ads');
});
//Session item setting for category modal content
$(".ads-cat-modal").on("click", function (e) {
    sessionStorage.setItem('cat-content', 'ads');
});
//Session item setting for category modal content
$(".prd-cat-modal").on("click", function (e) {
    sessionStorage.setItem('cat-content', 'prd');
});


$(".to-products-ads-close").on("click", function (e) {
    $(".to-products-ads").attr('style','display:none !important');
});



function categoryContentChecker() {
    let categoryContent = sessionStorage.getItem('cat-content');
    if (categoryContent == 'ads') {
        let adCategoryItem = $('.ad-category-item');
        let productCategoryItem = $('.product-category-item');
        let mainFooter = $('#footer');

        let latestAdsFooterLi = $('.ads-cat-modal-li');
        let latestPrdFooterLi = $('.prd-cat-modal-li');

        latestAdsFooterLi.removeClass('d-none');
        latestPrdFooterLi.addClass('d-none');

        productCategoryItem.addClass('d-none');
        adCategoryItem.removeClass('d-none');
        mainFooter.attr('style','display:block !important');
    } else if (categoryContent == 'prd') {
        let productCategoryItem = $('.product-category-item');
        let latestAdsFooterButton = $('.latest-ads-footer');
        let mainFooter = $('#footer');

        //for change the category content
        latestAdsFooterButton.attr('href', '/c/pet_products?sort_by=sort_time');
        latestAdsFooterButton.removeClass('ads-cat-modal');
        productCategoryItem.removeClass('d-none');
        mainFooter.attr('style','display:block !important');

    }
}

// If media query matches
if (window.matchMedia("(min-width: 576px)").matches) {
    $(".navbar-evcil-ilan").addClass("navbar-sahibinden");
    $(".navbar-evcil-ilan").removeClass("navbar-evcil-ilan");
};
$(function () {
    if (window.location.pathname == '/') {
        sessionStorage.removeItem('cat-content');
    }
    categoryContentChecker();
});


