<?php namespace Visiosoft\PetTheme\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Http\Request;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\Http\Controller\AjaxController;
use Visiosoft\DopingsModule\Doping\DopingModel;

class PetThemeController extends PublicController
{

    public function getFeatures($typeId, $catId, DopingModel $model, AdvModel $advModel)
    {
        $featuredAdvs = $model->getFeaturedAdvs($typeId, 2, $catId);
        $ads = $advModel->getLocationNames($featuredAdvs);

        foreach ($ads as $index => $ad) {
            $ads[$index]->detail_url = $advModel->getAdvDetailLinkByModel($ad, 'list');
            $ads[$index] = $advModel->AddAdsDefaultCoverImage($ad);
        }

        return $this->view->make('visiosoft.theme.pet::mobile/single-featured-ad', compact('ads'))->render();

    }

    public function getCategories(Request $request, AjaxController $ajaxController)
    {
        $categories = $ajaxController->categories($request);
        $cats = json_decode(json_encode($categories), true);

        return $this->view->make('visiosoft.theme.pet::mobile/single-cat-item', compact('cats'))->render();
    }

    public function getAdvsByCat($categoryID, $level = 1, AdvRepositoryInterface $advRepository)
    {
        $ads = $advRepository->getByCat($categoryID, $level);
        return $this->view->make('visiosoft.theme.pet::mobile/single-last-ad', compact('ads'))->render();

    }

    public function redirectDetail(AdvRepositoryInterface $advRepository, $slug)
    {
        try {
            $parameters = explode('-', $slug);
            $id = end($parameters);
            if (!$adv = $advRepository->find($id)) {
                abort(404);
            }

            return $this->redirect->to('ilan/' . $adv->getAttribute('slug') . '/' . $adv->getId());
        } catch (\Exception $exception) {
            abort(404);
        }
    }
}
