<?php namespace Visiosoft\PaypalWebhooksExtension\Commands;

class ResponseValues
{
    public $values;

    public function __construct($values)
    {
        $this->values = $values;
    }

    public function getResource()
    {
        return $this->values['resource'];
    }

    public function getDescription()
    {
        return $this->getResource()['description'];
    }

    public function getInvoiceID()
    {
        return $this->getResource()['invoice_id'];
    }

    public function getAmount()
    {
        return floatval($this->getResource()['purchase_units'][0]['amount']['value']);
    }

    public function getCurrenyCode()
    {
        return $this->getResource()['purchase_units'][0]['amount']['currency_code'];
    }
}
